/*
 * Decompiled with CFR 0.152.
 */
package com.chocohead.mm;

import com.chocohead.mm.CasualStreamHandler;
import com.chocohead.mm.EnumExtender;
import com.chocohead.mm.EnumSubclasser;
import com.chocohead.mm.Extension;
import com.chocohead.mm.MM;
import com.chocohead.mm.UnremovableMap;
import com.chocohead.mm.api.ClassTinkerers;
import com.chocohead.mm.api.EnumAdder;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.metadata.CustomValue;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InnerClassNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.spongepowered.asm.mixin.MixinEnvironment;
import org.spongepowered.asm.mixin.extensibility.IMixinConfigPlugin;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;
import org.spongepowered.asm.mixin.transformer.ext.Extensions;
import org.spongepowered.asm.mixin.transformer.ext.IExtension;
import org.spongepowered.asm.mixin.transformer.ext.extensions.ExtensionClassExporter;

public final class Plugin
implements IMixinConfigPlugin {
    final List<String> mixins = new ArrayList<String>();
    final Map<String, String> enumStructParents = new HashMap<String, String>();
    private Map<String, Set<Consumer<ClassNode>>> classModifiers;
    private static final int ACCESSES = -8;

    private static Consumer<URL> fishAddURL() {
        ClassLoader loader = Plugin.class.getClassLoader();
        Method addUrlMethod = null;
        for (Method method : loader.getClass().getDeclaredMethods()) {
            if (method.getReturnType() != Void.TYPE || method.getParameterCount() != 1 || method.getParameterTypes()[0] != URL.class) continue;
            addUrlMethod = method;
            break;
        }
        if (addUrlMethod == null) {
            throw new IllegalStateException("Couldn't find method in " + loader);
        }
        try {
            addUrlMethod.setAccessible(true);
            MethodHandle handle = MethodHandles.lookup().unreflect(addUrlMethod);
            return url -> {
                try {
                    handle.invoke(loader, (URL)url);
                }
                catch (Throwable t) {
                    throw new RuntimeException("Unexpected error adding URL", t);
                }
            };
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Couldn't get handle for " + addUrlMethod, e);
        }
    }

    public void onLoad(String rawMixinPackage) {
        final String mixinPackage = rawMixinPackage.replace('.', '/');
        HashMap<String, Set> transforms = new HashMap<String, Set>();
        try {
            Enumeration<URL> urls = MM.class.getClassLoader().getResources("silky.at");
            while (urls.hasMoreElements()) {
                URL url = urls.nextElement();
                Scanner scanner = new Scanner(url.openStream());
                Throwable throwable = null;
                try {
                    while (scanner.hasNextLine()) {
                        String method;
                        Field[] className;
                        Field[] line = scanner.nextLine().trim();
                        if (line.isEmpty() || line.startsWith("#")) continue;
                        int split = line.indexOf(32);
                        if (split > 0) {
                            className = line.substring(0, split++);
                            method = line.substring(split);
                        } else {
                            className = line;
                            method = "<*>";
                        }
                        transforms.computeIfAbsent((String)className, k -> new HashSet()).add(method);
                    }
                }
                catch (Throwable line) {
                    throwable = line;
                    throw line;
                }
                finally {
                    if (scanner == null) continue;
                    if (throwable != null) {
                        try {
                            scanner.close();
                        }
                        catch (Throwable line) {
                            throwable.addSuppressed(line);
                        }
                        continue;
                    }
                    scanner.close();
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Error loading access transformers", e);
        }
        for (Map.Entry entry : transforms.entrySet()) {
            ClassTinkerers.addTransformation((String)entry.getKey(), Plugin.makeAT((Set)entry.getValue()));
        }
        final HashMap<String, byte[]> classGenerators = new HashMap<String, byte[]>();
        final HashMap<String, Set<Consumer<ClassNode>>> classModifiers = new HashMap<String, Set<Consumer<ClassNode>>>(){
            private static final long serialVersionUID = 4152702952480161028L;
            private boolean skipGen = false;
            private int massPool = 1;

            private void generate(String name, Collection<? extends String> targets) {
                assert (name.indexOf(46) < 0);
                classGenerators.put('/' + mixinPackage + name + ".class", Plugin.makeMixinBlob(mixinPackage + name, targets));
                Plugin.this.mixins.add(name.replace('/', '.'));
            }

            @Override
            public Set<Consumer<ClassNode>> put(String key, Set<Consumer<ClassNode>> value) {
                if (!this.skipGen) {
                    this.generate(key, Collections.singleton(key));
                }
                return super.put(key, value);
            }

            @Override
            public void putAll(Map<? extends String, ? extends Set<Consumer<ClassNode>>> m) {
                this.skipGen = true;
                this.generate("MassExport_" + this.massPool++, m.keySet());
                super.putAll(m);
                this.skipGen = false;
            }
        };
        final HashMap<String, Consumer<ClassNode>> classReplacers = new HashMap<String, Consumer<ClassNode>>(){
            private static final long serialVersionUID = -1226882557534215762L;
            private boolean skipGen = false;

            @Override
            public Consumer<ClassNode> put(String key, Consumer<ClassNode> value) {
                if (!this.skipGen && !classModifiers.containsKey(key)) {
                    classModifiers.put(key, new HashSet());
                }
                return super.put(key, value);
            }

            @Override
            public void putAll(Map<? extends String, ? extends Consumer<ClassNode>> m) {
                this.skipGen = true;
                classModifiers.putAll(Maps.asMap(m.keySet(), name -> classModifiers.getOrDefault(name, new HashSet())));
                super.putAll(m);
                this.skipGen = false;
            }
        };
        HashSet<EnumAdder> enumExtenders = new HashSet<EnumAdder>(){
            private static final long serialVersionUID = -2218861530200989346L;
            private boolean skipCheck = false;

            private void addTransformations(EnumAdder builder) {
                ClassTinkerers.addTransformation(builder.type, EnumExtender.makeEnumExtender(builder));
                for (EnumAdder.EnumAddition addition : builder.getAdditions()) {
                    if (!addition.isEnumSubclass()) continue;
                    ClassTinkerers.addReplacement(addition.structClass, EnumSubclasser.makeStructFixer(addition, builder.type));
                    for (EnumSubclasser.StructClass node : EnumSubclasser.getParentStructs(addition.structClass)) {
                        String lastEnum = Plugin.this.enumStructParents.put(node.name, builder.type);
                        assert (lastEnum == null || lastEnum.equals(builder.type));
                    }
                }
                Plugin.this.enumStructParents.keySet().removeAll(classReplacers.keySet());
            }

            @Override
            public boolean add(EnumAdder builder) {
                if (!this.skipCheck) {
                    this.addTransformations(builder);
                }
                return super.add(builder);
            }

            @Override
            public boolean addAll(Collection<? extends EnumAdder> builders) {
                this.skipCheck = true;
                for (EnumAdder enumAdder : builders) {
                    this.addTransformations(enumAdder);
                }
                boolean out = super.addAll(builders);
                this.skipCheck = false;
                return out;
            }

            @Override
            public boolean remove(Object o) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean removeIf(Predicate<? super EnumAdder> filter) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean removeAll(Collection<?> c) {
                throw new UnsupportedOperationException();
            }
        };
        ClassTinkerers.INSTANCE.hookUp(Plugin.fishAddURL(), (Map<String, byte[]>)((Object)new UnremovableMap(classGenerators)), (Map<String, Consumer<ClassNode>>)((Object)new UnremovableMap<String, Consumer<ClassNode>>(classReplacers)), (Map<String, Set<Consumer<ClassNode>>>)((Object)new UnremovableMap<String, Set<Consumer<ClassNode>>>(classModifiers)), (Set<EnumAdder>)enumExtenders);
        ClassTinkerers.addURL(CasualStreamHandler.create(classGenerators));
        this.classModifiers = classModifiers;
        Object transformer = MixinEnvironment.getCurrentEnvironment().getActiveTransformer();
        if (transformer == null) {
            throw new IllegalStateException("Not running with a transformer?");
        }
        Extensions extensions = null;
        try {
            for (Field f2 : transformer.getClass().getDeclaredFields()) {
                if (f2.getType() != Extensions.class) continue;
                f2.setAccessible(true);
                extensions = (Extensions)f2.get(transformer);
                break;
            }
            if (extensions == null) {
                String foundFields = Arrays.stream(transformer.getClass().getDeclaredFields()).map(f -> f.getType() + " " + f.getName()).collect(Collectors.joining(", "));
                throw new NoSuchFieldError("Unable to find extensions field, only found " + foundFields);
            }
        }
        catch (ReflectiveOperationException e) {
            throw new IllegalStateException("Running with a transformer that doesn't have extensions?", e);
        }
        extensions.add((IExtension)new Extension(mixinPackage, (Map<String, Consumer<ClassNode>>)classReplacers));
        ExtensionClassExporter exporter = (ExtensionClassExporter)extensions.getExtension(ExtensionClassExporter.class);
        CasualStreamHandler.dumper = (name, bytes) -> {
            ClassNode node = new ClassNode();
            new ClassReader(bytes).accept((ClassVisitor)node, 8);
            exporter.export(MixinEnvironment.getCurrentEnvironment(), name, false, node);
        };
    }

    static byte[] makeMixinBlob(String name, Collection<? extends String> targets) {
        ClassWriter cw = new ClassWriter(0);
        cw.visit(52, 1537, name, null, "java/lang/Object", null);
        AnnotationVisitor mixinAnnotation = cw.visitAnnotation("Lorg/spongepowered/asm/mixin/Mixin;", false);
        AnnotationVisitor targetAnnotation = mixinAnnotation.visitArray("value");
        for (String string : targets) {
            targetAnnotation.visit(null, (Object)Type.getType((String)('L' + string + ';')));
        }
        targetAnnotation.visitEnd();
        mixinAnnotation.visitEnd();
        cw.visitEnd();
        return cw.toByteArray();
    }

    private static Consumer<ClassNode> makeAT(Set<String> transforms) {
        return node -> {
            if (transforms.remove("<*>")) {
                node.access = Plugin.flipBits(node.access);
                for (InnerClassNode innerClass : node.innerClasses) {
                    if (!node.name.equals(innerClass.name)) continue;
                    innerClass.access = Plugin.flipBits(innerClass.access);
                    break;
                }
            }
            if (!transforms.isEmpty()) {
                for (MethodNode method : node.methods) {
                    if (transforms.contains(method.name + method.desc)) {
                        method.access = Plugin.flipBits(method.access);
                    }
                    for (AbstractInsnNode insnNode : method.instructions) {
                        if (insnNode.getOpcode() != 183) continue;
                        MethodInsnNode methodInsnNode = (MethodInsnNode)insnNode;
                        if (methodInsnNode.name.equals("<init>") || !methodInsnNode.owner.equals(node.name) || !transforms.contains(methodInsnNode.name + methodInsnNode.desc)) continue;
                        methodInsnNode.setOpcode(182);
                    }
                }
            }
        };
    }

    private static int flipBits(int access) {
        access &= 0xFFFFFFF8;
        access |= 1;
        return access &= 0xFFFFFFEF;
    }

    public String getRefMapperConfig() {
        return null;
    }

    public List<String> getMixins() {
        FabricLoader.getInstance().getEntrypoints("mm:early_risers", Runnable.class).forEach(Runnable::run);
        for (ModContainer modContainer : FabricLoader.getInstance().getAllMods()) {
            if (!modContainer.getMetadata().containsCustomValue("mm:early_risers")) continue;
            System.out.println(modContainer.getMetadata().getName() + " is still using the traditional Early Riser initialisation");
            for (CustomValue riser : modContainer.getMetadata().getCustomValue("mm:early_risers").getAsArray()) {
                try {
                    Class.forName(riser.getAsString()).asSubclass(Runnable.class).newInstance().run();
                }
                catch (ReflectiveOperationException e) {
                    throw new RuntimeException("Error loading early riser from " + modContainer.getMetadata().getId(), e);
                }
            }
        }
        if (!this.enumStructParents.isEmpty()) {
            for (Map.Entry entry : this.enumStructParents.entrySet()) {
                ClassTinkerers.addReplacement((String)entry.getKey(), EnumSubclasser.makeStructFixer((String)entry.getKey(), (String)entry.getValue()));
            }
        }
        return this.mixins;
    }

    public void acceptTargets(Set<String> myTargets, Set<String> otherTargets) {
    }

    public boolean shouldApplyMixin(String targetClassName, String mixinClassName) {
        return true;
    }

    public void preApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
        Set<Consumer<ClassNode>> transformations = this.classModifiers.get(targetClassName.replace('.', '/'));
        if (transformations != null) {
            for (Consumer<ClassNode> transformer : transformations) {
                transformer.accept(targetClass);
            }
        }
    }

    public void postApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
        targetClass.interfaces.remove(mixinClassName.replace('.', '/'));
    }
}

